#include <algorithm>
#include <iostream>
#include <vector>
#include <set>
using namespace std;

bool dfs(int parent, int node, int end_node, const vector<vector<int>>& graph, set<int>& elements_on_path)
{
	elements_on_path.insert(node);
	if (node == end_node)
	{
		return true;
	}
	for (int neighbor : graph[node])
	{
		if (neighbor != parent)
		{
			bool done = dfs(node, neighbor, end_node, graph, elements_on_path);
			if (done)
				return true;
		}
	}
	elements_on_path.erase(node);
	return false;
}

set<int> elements_on_path(int a, int b, const vector<vector<int>>& graph)
{
	set<int> elements;
	dfs(-1, a, b, graph, elements);
	return elements;
}

int solve_query(int node_a1, int node_a2, int node_b1, int node_b2, const vector<vector<int>>& tree1, const vector<vector<int>>& tree2)
{
	set<int> elems1 = elements_on_path(node_a1, node_a2, tree1);
	set<int> elems2 = elements_on_path(node_b1, node_b2, tree2);
	int intersection_cnt = 0;
	for (int i: elems1)
	{
		if (elems2.find(i) != elems2.end())
		{
			intersection_cnt++;
		}
	}
	return intersection_cnt;
}

void Resi(int N, int Q, int P, int* U1, int* V1, int* U2, int* V2, int* A1, int* B1, int* C1, int* D1, int* R)
{
	vector<vector<int>> tree1(N, vector<int>());
	auto tree2 = tree1;
	for (int i = 0; i < N-1; i++)
	{
		int u1 = U1[i + 1], v1 = V1[i + 1];
		int u2 = U2[i + 1], v2 = V2[i + 1];
		u1--; v1--; u2--; v2--;
		tree1[u1].push_back(v1);
		tree1[v1].push_back(u1);

		tree2[u2].push_back(v2);
		tree2[v2].push_back(u2);
	}
	for (int i = 0; i < Q; i++)
	{
		int node_a1 = (A1[i + 1]-1)%N+1, node_a2 = (B1[i + 1] - 1) % N + 1;
		int node_b1 = (C1[i + 1] - 1) % N + 1, node_b2 = (D1[i + 1] - 1) % N + 1;
		node_a1--; node_a2--; node_b1--; node_b2--;

		int sol = solve_query(node_a1, node_a2, node_b1, node_b2, tree1, tree2);
		R[i + 1] = sol;
	}
}